<?php

require('WFilterNGF.php');

error_reporting(E_ALL);
date_default_timezone_set("PRC");

class WSGAPI extends WFilterNGF{
	//获取WSG状态
	public function get_wsg_status(){
		$msg = "";
		$data = "{}";
		$this->rpc_call( "wfilter", "status", $data, $msg );
		return $msg;
	}
	//获取IPS状态
	public function get_ips_status(){
		$msg = "";
		$data = "{\"data\":\"wfilter-tools -s service wfilter-snortd getstats\"}";
		$this->rpc_call( "wfilter", "exec", $data, $msg );
		return $msg;
	}
}

$wsg_array=[
    [
		"ip" => "192.168.1.1",
		"title" => "WSG1",
        "user" => "admin",
        "pass" => "123456"
    ],
    [
		"ip" => "192.168.1.13",
		"title" => "WSG13",
        "user" => "admin",
        "pass" => "123456"
    ],
	[
		"ip" => "192.168.1.250",
		"title" => "WSG250",
        "user" => "admin",
        "pass" => "123456"
    ],
	[
		"ip" => "192.168.2.6",
		"title" => "WSG26",
        "user" => "admin",
        "pass" => "123456"
    ],
	[
		"ip" => "192.168.2.7",
		"title" => "WSG27",
        "user" => "admin",
        "pass" => "123456"
    ]
];

$ngfcnt = 0;

echo "{\n";
echo "\"servers\": [\n";
foreach( $wsg_array as $def) {
    $ngf = new WSGAPI();
	if( $ngf->login( "http://" . $def["ip"], $def["user"], $def["pass"] )){
		$ngfcnt++;
		$bandwidth = $ngf->list_bandwidth( 30 );
		$wsgstatus = $ngf->get_wsg_status();
		$ipsstatus = $ngf->get_ips_status();
		$ngf->logout();
		if( $ngfcnt > 1 ){
			echo ",";
		}
		echo "	{\n";
		echo "		\"ip\": \"" . $def["ip"] . "\", \n";
		echo "		\"name\": \"" . urlencode($def["title"]) . "\", \n";
		echo "		\"bandwidth\": \"" . urlencode($bandwidth) . "\", \n";
		echo "		\"wsgstatus\": \"" . urlencode($wsgstatus) . "\", \n";
		echo "		\"ipsstatus\": \"" . urlencode($ipsstatus) . "\" \n";
		echo "	}\n";
	}
}
echo "],\n";
echo "\"ngfcnt\": " . $ngfcnt . "\n";
echo "}\n";
?>
