var APIDemo = {
	"maxbandwidth" : 100, //带宽纵坐标
	"maxduring" : 30       //流量图30秒
};

APIDemo.reload = function(){
	var d = new Date();
	$("#curtime").html( d.toLocaleString() );
	$.ajax( "apidemo.php", {
		method: 'GET',
		cache: false,
		dataType: 'text',
		success: function(data) {
			var jsonData = eval('(' + data + ')');
			//console.log("apidemo.php2=" + JSON.stringify(jsonData));
			$("#devices").html( jsonData.ngfcnt );
			if( $.isArray(jsonData.servers)){
				APIDemo.renewBandWidth( jsonData.servers );
				APIDemo.renewClient( jsonData.servers );
				APIDemo.renewIPS( jsonData.servers );
				$("#wsg_login").empty();
				for( var i=0; i<jsonData.servers.length; i++ ){
					$("#wsg_login").append( "<option value=\"" + jsonData.servers[i].ip + "\">" + jsonData.servers[i].name +"</option>");
				}
			}
		}
	});
	setTimeout( "APIDemo.reload()", 5000 );
};

APIDemo.open_login = function(){
	window.open( "http://" + $("#wsg_login").val() );
};

APIDemo.resetTime = function( cnt ){
	var	tt = new	Date();
	var	tmpArray = new Array();
	for( var i = cnt; i > 0; ){
		tmpArray.push("");
		i = i - cnt/APIDemo.maxduring;
	}
	return tmpArray;
};

APIDemo.resetData = function( cnt ){
	var	tmpArray = new Array();
	for( var i = cnt; i > 0; ){
		tmpArray.push(0);
		i = i - cnt/APIDemo.maxduring;
	}
	return tmpArray;
};

APIDemo.renewBandWidth = function( servers ){
	if(typeof window.myLine === "undefined"){
		var lineChartData = {
			labels : APIDemo.resetTime( APIDemo.maxduring ),
			datasets : []
		};
		for( var i=0; i<servers.length; i++ ){
			var color = "rgb(" + Math.random()*255 + "," + Math.random()*255 + "," + Math.random()*255 + ")";
			lineChartData.datasets.push(
				{
					label: servers[i].name +"(Mb)",
					borderColor : color,
					backgroundColor : color,
					cubicInterpolationMode: 'monotone',
					data: APIDemo.resetData( APIDemo.maxduring )
				}
			);
		}
		var canvas = document.getElementById("bwcanvas");
		var ctx = canvas.getContext("2d");
		canvas.width = 500;
		canvas.height = 200;
		try{
			window.myLine = new Chart(ctx,
				{
					type: 'line',
					data: lineChartData,
					options: {
						responsive: false,
						scales: {
							yAxes: {
								beginAtZero: true,
								max : APIDemo.maxbandwidth,
								ticks: {
									stepSize: APIDemo.maxbandwidth/5
								},
								grid:{
									drawBorder: false
								}
							},
							xAxes: {
								ticks: {
									display: false
								},
								grid: {
									display: false
								}
							}
						},
						interaction: {
							intersect: false,
							mode: 'index',
						},
						plugins: {
							legend: {
								display: false
							},
							title: {
								display: true,
								text: '实时流量汇总图',
								font: {	size: 18 }					
							}
						}
					}
				}
			);
		}catch(err){
		}
	}
	
	for( var i=0; i<servers.length; i++ ){
		//console.log("apidemo.renewBandWidth11=" + servers[i].bandwidth);
		//console.log("apidemo.renewBandWidth111=" + decodeURIComponent(servers[i].bandwidth));
		//console.log("apidemo.renewBandWidth112=" + decodeURIComponent(servers[i].bandwidth).replace(/\+/g, ' '));
		var bwarray = eval('(' + decodeURIComponent(servers[i].bandwidth).replace(/\+/g, ' ') + ')');
		//console.log("apidemo.renewBandWidth22=" + JSON.stringify(bwarray));
		if( $.isArray(bwarray.result) && bwarray.result.length > 1 && bwarray.result[1].result != undefined ){
			var jsonData = eval('(' + bwarray.result[1].result + ')').bandwidth;
			//console.log("apidemo.renewBandWidth2221=" + JSON.stringify(jsonData));
			for( var j = 0; j < jsonData.length; j++ ){
				var bwtemp = jsonData[j];
				//console.log("apidemo.renewBandWidth, bwtemp=" + JSON.stringify(bwtemp)+",temp="+temp+",i=" + i +",j="+j);
				window.myLine.data.datasets[i].data[j] = ((bwtemp.up+bwtemp.down)*8/(1024.0*1024.0)).toFixed(2);
			}
		}
	}
	window.myLine.update();
};

APIDemo.renewClient = function( servers ){
	if(typeof window.myBar === "undefined"){
		var barChartData = {
			labels : [],
			datasets : [
				{
					borderColor : "rgb(0,0,0)",
					backgroundColor : [],
					data : []
				}
			]
		}
		for( var i=0; i<servers.length; i++ ){
			var color = "rgb(" + Math.random()*255 + "," + Math.random()*255 + "," + Math.random()*255 + ")";
			barChartData.labels.push("");
			barChartData.datasets[0].data.push("");
			barChartData.datasets[0].backgroundColor.push(color);
		}
		var canvas = document.getElementById("clientcanvas");
		var ctx = canvas.getContext("2d");
		canvas.width = 500;
		canvas.height = 200;
		window.myBar = new Chart(ctx,
			{
			type: 'bar',
			data: barChartData,
			options: 			{
					responsive: false,
					scales: {
						yAxes: {
							beginAtZero: true,
							grid:{
								drawBorder: false
							}
						},
						xAxes: {
							ticks: {
								display: false
							},
							grid: {
								display: false
							}
						}
					},
					plugins: {
						legend: {
							display: false
						},
						tooltip: {
							displayColors: false
						},
						title: {
							display: true,
							text: '实时终端数',
							font: {	size: 18 }
						}
					}
				}

		});
	}
	var total_onlinecnt = 0;
	for( var i=0; i<servers.length; i++ ){
		//console.log("apidemo.renewBandWidth11=" + servers[i].bandwidth);
		//console.log("apidemo.renewBandWidth111=" + decodeURIComponent(servers[i].bandwidth));
		//console.log("apidemo.renewBandWidth112=" + decodeURIComponent(servers[i].bandwidth).replace(/\+/g, ' '));
		var cliarray = eval('(' + decodeURIComponent(servers[i].wsgstatus).replace(/\+/g, ' ') + ')');
		var onlinecnt = 0;
		if( $.isArray(cliarray.result) && cliarray.result.length > 1 && cliarray.result[1].result != undefined ){
			onlinecnt = eval('(' + cliarray.result[1].result + ')').onlinecnt;
		}
		total_onlinecnt += onlinecnt;
		window.myBar.data.labels[i] = servers[i].name;
		window.myBar.data.datasets[0].data[i] = onlinecnt;
	}
	window.myBar.update();
	$("#clients").html( total_onlinecnt );
};

APIDemo.renewIPS = function( servers ){
	var str_ips = "";
	for( var i=0; i<servers.length; i++ ){
		//console.log("apidemo.renewBandWidth11=" + servers[i].bandwidth);
		//console.log("apidemo.renewBandWidth111=" + decodeURIComponent(servers[i].bandwidth));
		//console.log("apidemo.renewIPS111=" + decodeURIComponent(servers[i].ipsstatus).replace(/\+/g, ' '));
		var ipsstatus = eval('(' + decodeURIComponent(servers[i].ipsstatus).replace(/\+/g, ' ') + ')');
		var alertcnt = 0;
		if( $.isArray(ipsstatus.result) && ipsstatus.result.length > 1 && ipsstatus.result[1].stdout != undefined ){
			//console.log("apidemo.renewIPS222=" + ipsstatus.result[1].stdout);
			alertcnt = eval('(' + ipsstatus.result[1].stdout + ')').alerts;
		}
		if( alertcnt > 0 ){
			str_ips += "<tr><td>" + servers[i].ip + "</td><td>" + alertcnt + "</td></tr>";
		}
	}
	$("#table_ips tbody").html( str_ips );
};
