<?php

class WFilterNGF
{

	public $session_id = "00000000000000000000000000000000";
	private $cmd_id = 1;
	private $server;
	
	//APIýӿ
	protected function rpc_call( $object, $method, $para, &$msg ){
		$ret = false;
		$headers = array();
		$headers[] = 'Content-Type: application/json';

		$ch = curl_init( $this->server . "/ubus" );

		curl_setopt( $ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_FORBID_REUSE, 1);
		curl_setopt( $ch, CURLOPT_CONNECTTIMEOUT, 20 );
		curl_setopt( $ch, CURLOPT_HTTPHEADER, $headers );
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);

		$post_data = "{\"jsonrpc\":\"2.0\","
			. "\"id\":" . $this->cmd_id++ . ",
			\"method\":\"call\",
			\"params\":[ \"" . $this->session_id . "\", \"" . $object . "\", \"" . $method . "\"," . $para . " ]}";

		curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data );
		$res = curl_exec($ch);
		if( !($res)) {
			$errno = curl_errno($ch);
			$errstr = curl_error($ch);
		}else{
			$msg = $res;
			$ret = true;
		}
		curl_close($ch);
		return $ret;
	}
	
	//¼NGF, ¼ɹſԵAPI
	public function login( $server, $username, $password ){
		$msg = "";
		$data = "{\"username\":\"" . $username . "\",\"password\":\"" . md5($password) . "\"}";
		$this->server = $server;
		if( $this->rpc_call( "session", "login", $data, $msg )){
			$findme = "\"ubus_rpc_session\":\"";
			$pos = strpos( $msg, $findme );
			if( $pos ){
				$this->session_id = substr( $msg, $pos+strlen($findme), 32 );
				//echo "session_id=" . $this->session_id . "<br>";
				return true;
			}
		}
		return false;
	}
	//˳¼NGF
	public function logout(){
		$msg = "";
		$this->rpc_call( "session", "destroy", "", $msg );
	}
	//renew_userӪеӳûޡ
	public function renew_user( $userid, $newdate ){
		$msg = "";
		$data = "{\"data\":\"wfilter-isp renew " . $userid . " " . $newdate . "\"}";
		if( $this->rpc_call( "wfilter", "exec", $data, $msg )){
			if( strpos( $msg, $newdate ) != FALSE ){
				return true;
			}
		}
		return false;
	}
	//add_virtual_group: ipûӵNӣuseripû
	//IDͨڡģ顱->->СִСuci show wfilter-groupsȡ磺group1498286802318
	public function add_virtual_group( $groupid, $ip, $minutes ){
		$msg = "";
		$data = "{\"id\":\"" . $groupid . "\",\"ip\":\"" . $ip . "\",\"minute\":\"" . $minutes . "\"}";
		if( $this->rpc_call( "wfilter", "add-virtual-group", $data, $msg )){
			if( strpos( $msg, "0000" ) != FALSE ){
				return true;
			}
		}
		return false;
	}
	//rm_virutal_groupipûƳ
	public function rm_virtual_group( $ip ){
		$msg = "";
		$data = "{\"data\":\"" . $ip . "\"}";
		if( $this->rpc_call( "wfilter", "rm-virtual-group", $data, $msg )){
			if( strpos( $msg, "0000" ) != FALSE ){
				return true;
			}
		}
		return false;
	}
	//ȡûб
	public function list_group(){
		$msg = "";
		$data = "{\"config\":\"wfilter-groups\"}";
		$this->rpc_call( "uci", "get", $data, $msg );
		return $msg;
	}
	//ȡ˺б
	public function list_account(){
		$msg = "";
		$data = "{\"config\":\"wfilter-account\"}";
		$this->rpc_call( "uci", "get", $data, $msg );
		return $msg;
	}
	//ȡһʱڵÿϴشʱʵʱͼõʱ
	public function list_bandwidth( $seconds ){
		$msg = "";
		$data = "{\"data\":\"" . $seconds . "\"}";
		$this->rpc_call( "wfilter", "list-bandwidth", $data, $msg );
		return $msg;
	}
	/*ȡ豸б
	 * top: ֻǰN¼󲻳1000
	 * search: ֻطIP"192.168.1"
	 */
	public function list_online_users( $top, $search ){
		$msg = "";
		$data = "{\"row\":\"" . $top . "\", \"search\":\"" . $search ."\"}";
		$this->rpc_call( "wfilter", "get-top-bandwidth", $data, $msg );
		return $msg;
	}
	//ȡһIP
	public function list_online_connections( $ip ){
		$msg = "";
		$data = "{\"data\":\"" . $ip . "\"}";
		$this->rpc_call( "wfilter", "get-links", $data, $msg );
		return $msg;
	}
	/*Ͽӣûߣ
	 * port -- ӵıض˿ڣ0 -- ж˿
	 * type -- "ALL"--Э飬"RESET"--ã"REMOVE"--ȫУ--Э
	 * minutes -- Nӣʱ
	 * message -- ͵Ϣurlencode
	 */
	public function kill_connection( $ip, $port, $type, $minutes, $message ){
		$msg = "";
		$data = "{\"ip\":\"" . $ip . "\",\"port\":\"" . $port . "\",\"proto\":\"". $type . "\",\"minutes\":\"". $minutes . "\",\"message\":\"". $message . "\"}";
		if( $this->rpc_call( "wfilter", "kill-link", $data, $msg )){
			if( strpos( $msg, "0000" ) != FALSE ){
				return true;
			}
		}
		return false;
	}
	/* ȡӿб */
	public function get_network_interfaces(){
		$msg = "";
		$this->rpc_call( "network.interface", "dump", "{}", $msg );
		return $msg;
	}
	/* ȡӿڵ״̬ */
	public function get_network_status(){
		$msg = "";
		$this->rpc_call( "network.device", "status", "{}", $msg );
		return $msg;
	}
	/* ûIP
	 * user: û(urlencode)
	 * from: ڣ磺webauth, pppoe
	 * expire: ʱڣ룩
	*/
	public function add_user( $ip, $user, $from, $expire ){
		$msg = "";
		$data = "{\"ip\":\"" . $ip . "\",\"user\":\"" . $user . "\",\"from\":\"". $from . "\",\"expire\":\"". $expire . "\"}";
		if( $this->rpc_call( "wfilter", "add-user", $data, $msg )){
			if( strpos( $msg, "0000" ) != FALSE ){
				return true;
			}
		}
		return false;
	}
	/* ȡû
	 * 룺ipû(urlencode)
	*/
	public function rm_user( $user ){
		$msg = "";
		$data = "{\"data\":\"" . $user . "\"}";
		if( $this->rpc_call( "wfilter", "rm-user", $data, $msg )){
			if( strpos( $msg, "0000" ) != FALSE ){
				return true;
			}
		}
		return false;
	}
	//ȡļ
	public function config_load( $cfgname ){
		$msg = "";
		$data = "{\"config\":\"" . $cfgname . "\"}";
		$this->rpc_call( "uci", "get", $data, $msg );
		return $msg;
	}
	//
	public function config_add( $cfgname, $type, $name, $values ){
		$msg = "";
		$data = "{\"config\":\"" . $cfgname . "\",\"type\":\"" . $type . "\",\"name\":\"" . $name . "\",\"values\":" . $values . "}";
		$this->rpc_call( "uci", "add", $data, $msg );
		return $msg;
	}
	//޸
	public function config_set( $cfgname, $section, $values ){
		$msg = "";
		$data = "{\"config\":\"" . $cfgname . "\",\"section\":\"" . $section . "\",\"values\":" . $values . "}";
		$this->rpc_call( "uci", "set", $data, $msg );
		return $msg;
	}
	//ɾ
	public function config_del( $cfgname, $section ){
		$msg = "";
		$data = "{\"config\":\"" . $cfgname . "\",\"section\":\"" . $section . "\"}";
		$this->rpc_call( "uci", "delete", $data, $msg );
		return $msg;
	}
	//Ӧ
	public function config_apply(){
		$msg = "";
		$data = "{\"data\":\"busybox sh /usr/sbin/wfilter-apply\"}";
		$this->rpc_call( "wfilter", "exec", $data, $msg );
		return $msg;
	}
	//ѯݿ
	public function query_db( $dbname, $querysql ){
		$msg = "";
		$data = "{\"dbname\":\"" . $dbname . "\",\"sql\":\"" . $querysql . "\"}";
		$this->rpc_call( "wfilter", "querydb", $data, $msg );
		return $msg;
	}
}

?>
