<?php

require('PaypalIPN.php');
require('WFilterNGF.php');

$ipn = new PaypalIPN();
$ngf = new WFilterNGF();
$success = false;
//$logfile = "debug.txt";
//Use the paypal sandbox endpoint during testing.
$ipn->useSandbox();
$ipn->usePHPCerts();

try {
	$verified = $ipn->verifyIPN();
}catch (Exception $e) {
    //file_put_contents( $logfile, 'Caught exception: ' .  $e->getMessage() . "\n" , FILE_APPEND | LOCK_EX);
}
if ($verified) {
	//file_put_contents($logfile, "paypay verifyIPN success.\n", FILE_APPEND | LOCK_EX);
    /*
     * Process IPN
     * A list of variables is available here:
     * https://developer.paypal.com/webapps/developer/docs/classic/ipn/integration-guide/IPNandPDTVariables/
     */
	$item_name = $_POST['item_name'];
	$item_number = $_POST['item_number'];
	$payment_status = $_POST['payment_status'];
	$payment_amount = $_POST['mc_gross'];
	$payment_currency = $_POST['mc_currency'];
	$txn_id = $_POST['txn_id'];
	$receiver_email = $_POST['receiver_email'];
	$payer_email = $_POST['payer_email'];
	
	//The token field, same as landing.php
	$token = $_POST['custom'];
	$value = base64_decode ( $token );
	$cols = explode( "\t", $value );
	
	if( count($cols) >= 4 ){
		//get next month date
		$valid_date = date('Y-m-d', strtotime('+1 month'));
		//1. For less risk, please do not use "admin" user to access.
		//2. Change imfirewall.dyndns.org to your ngf server IP.
		if( $ngf->login( "http://imfirewall.dyndns.org", "ispadmin", "123456" )){
			//file_put_contents($logfile, "login success.\n", FILE_APPEND | LOCK_EX);
			if( $ngf->renew_user( 
				$cols[0], 		//user id
				$valid_date		//new expire date
			)){
				//file_put_contents($logfile, "renew_user success.\n", FILE_APPEND | LOCK_EX);
				$success = true;	//renew user success
			}
		}
	}
}else{
	//file_put_contents($logfile, "paypay verifyIPN failure.\n" , FILE_APPEND | LOCK_EX);
}
// Reply with an empty 200 response to indicate to paypal the IPN was received correctly.
if( $success ){
	header("HTTP/1.1 200 OK");
}else{
	header("HTTP/1.1 501 Error");
}

?>
