<?php

class WFilterNGF
{

	private $session_id = "00000000000000000000000000000000";
	private $cmd_id = 1;
	private $server;
	
	private function rpc_call( $object, $method, $para, &$msg ){
		$ret = false;
		$headers = array();
		$headers[] = 'Content-Type: application/json';

		$ch = curl_init( $this->server . "/ubus" );

		curl_setopt( $ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_FORBID_REUSE, 1);
		curl_setopt( $ch, CURLOPT_CONNECTTIMEOUT, 20 );
		curl_setopt( $ch, CURLOPT_HTTPHEADER, $headers );
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);

		$post_data = "{\"jsonrpc\":\"2.0\","
			. "\"id\":" . $this->cmd_id++ . ",
			\"method\":\"call\",
			\"params\":[ \"" . $this->session_id . "\", \"" . $object . "\", \"" . $method . "\"," . $para . " ]}";

		curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data );
		$res = curl_exec($ch);
		if( !($res)) {
			$errno = curl_errno($ch);
			$errstr = curl_error($ch);
		}else{
			$msg = $res;
			$ret = true;
		}
		curl_close($ch);
		return $ret;
	}
	
	public function login( $server, $username, $password ){
		$msg = "";
		$data = "{\"username\":\"" . $username . "\",\"password\":\"" . md5($password) . "\"}";
		$this->server = $server;
		if( $this->rpc_call( "session", "login", $data, $msg )){
			$findme = "\"ubus_rpc_session\":\"";
			$pos = strpos( $msg, $findme );
			if( $pos ){
				$this->session_id = substr( $msg, $pos+strlen($findme), 32 );
				//echo "session_id=" . $this->session_id . "<br>";
				return true;
			}
		}
		return false;
	}
	
	public function renew_user( $userid, $newdate ){
		$msg = "";
		$data = "{\"data\":\"wfilter-isp renew " . $userid . " " . $newdate . "\"}";
		if( $this->rpc_call( "wfilter", "exec", $data, $msg )){
			if( strpos( $msg, $newdate ) != FALSE ){
				return true;
			}
		}
		return false;
	}
}

?>
